within EngineTestbench_JS_type.IFV_Lib.Diesel_Engine_test;
model Engine
parameter String tableNamePower;
parameter String tableNameTorque;
  Modelica.Blocks.Tables.CombiTable1D MAX_Torque(tableOnFile=true, tableName=
        tableNameTorque)
    annotation (Placement(transformation(extent={{-90,-74},{-70,-54}})));
  Modelica.Mechanics.Rotational.Sources.Torque torque
    annotation (Placement(transformation(extent={{30,22},{50,42}})));
  Modelica.Mechanics.Rotational.Components.Inertia inertia(J=1)
    annotation (Placement(transformation(extent={{54,22},{74,42}})));
  Modelica.Mechanics.Rotational.Components.BearingFriction bearingFriction
    annotation (Placement(transformation(extent={{80,22},{100,42}})));
  Modelica.Mechanics.Rotational.Interfaces.Flange_b flange   annotation (
      Placement(transformation(extent={{90,-20},{110,0}}), iconTransformation(
          extent={{90,-10},{110,10}})));
  Modelica.Blocks.Interfaces.RealInput Throttle
                                         annotation (Placement(transformation(
          extent={{-128,-32},{-88,8}}), iconTransformation(extent={{-120,-20},{-80,
            20}})));
  Modelica.Blocks.Tables.CombiTable1D MAX_Power(tableOnFile=true, tableName=
        tableNamePower)
    annotation (Placement(transformation(extent={{-90,-46},{-70,-26}})));
  Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedSensor
    annotation (Placement(transformation(extent={{40,-96},{20,-76}})));
  Modelica.Blocks.Math.Product product
    annotation (Placement(transformation(extent={{-60,-28},{-40,-8}})));
  Modelica.Blocks.Math.Product product1
    annotation (Placement(transformation(extent={{-32,-22},{-12,-2}})));
  Modelica.Blocks.Sources.Constant const(k=1000)
    annotation (Placement(transformation(extent={{-92,10},{-72,30}})));
  Modelica.Blocks.Math.Division division
    annotation (Placement(transformation(extent={{-48,32},{-28,52}})));
  Modelica.Blocks.Interfaces.RealOutput fuelFlow
    annotation (Placement(transformation(extent={{80,-58},{100,-38}})));
equation
  connect(torque.flange, inertia.flange_a) annotation (Line(
      points={{50,32},{54,32}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(inertia.flange_b, bearingFriction.flange_a) annotation (Line(
      points={{74,32},{80,32}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(bearingFriction.flange_b, flange)   annotation (Line(
      points={{100,32},{100,-10}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(speedSensor.flange, flange)   annotation (Line(
      points={{40,-86},{46,-86},{46,-10},{100,-10}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(speedSensor.w, MAX_Power.u[1]) annotation (Line(
      points={{19,-86},{-98,-86},{-98,-36},{-92,-36}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(speedSensor.w, MAX_Torque.u[1]) annotation (Line(
      points={{19,-86},{-92,-86},{-92,-64}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(Throttle, product.u1)
                         annotation (Line(
      points={{-108,-12},{-62,-12}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(MAX_Power.y[1], product.u2) annotation (Line(
      points={{-69,-36},{-66,-36},{-66,-24},{-62,-24}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(product.y, product1.u2) annotation (Line(
      points={{-39,-18},{-34,-18}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(const.y, product1.u1) annotation (Line(
      points={{-71,20},{-60,20},{-60,-2},{-34,-2},{-34,-6}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(product1.y, division.u1) annotation (Line(
      points={{-11,-12},{-10,-12},{-10,6},{-56,6},{-56,48},{-50,48}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(speedSensor.w, division.u2) annotation (Line(
      points={{19,-86},{-122,-86},{-122,36},{-50,36}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(division.y, torque.tau) annotation (Line(
      points={{-27,42},{0,42},{0,32},{28,32}},
      color={0,0,127},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")),
    Diagram(graphics),
    Icon(graphics={Text(
          extent={{-68,88},{84,-64}},
          lineColor={0,0,255},
          textString="IC Engine")}));
end Engine;
